# GANSpace experiment

This experiment gets participants to manipulate faces generated by a
Generative Adversarial Network (GAN).
In each trial, the participant manipulates a slider corresponding
to a principal component of the GAN's latent state.
These trials are combined together into Gibbs Sampling chains.

## Deploying

The experiment relies on an external server with a GPU for generating
the stimuli. The server is currently on AWS's EC2 service. When deploying
the experiment, you need to connect to this server to monitor the
stimulus generation process.

### Dallinger and stimulus generation

Dallinger makes a request to the GPU server each time a new node is created in the network.
This happens approximately every 5 trials. This triggers a call to `async_post_grow_network`,
which then makes an HTTP request to the GPU server. This HTTP request waits while
the stimulus is generated, and only finishes once the stimulus has been uploaded to S3.
If something goes wrong in this process, you will see an error in the Python log,
and typically an error also in the server log at `sudo journalctl -u ganspace -f`.

### What to watch out for

The main danger in this experiment is that recruitment is so fast that the GPU server can't keep up.
In this case, participants will finish the experiment early without completing the full number of trials.
You can see this behaviour by looking at the participant bonuses in the database;
low bonuses mean that the participant didn't complete many items.
Approximately speaking, since each stimulus is seen by 5 participants, each trial takes about 10 seconds,
and each stimulus takes 30 seconds to generate, the server can cope with 1-2 active participants
at a time, before it will start to run out of stimuli. Of course, this does not count participants
who are doing other parts of the experiment, and it does not count participants who have accepted the HIT
but have yet to begin it.
